/* main financial variables from waves1-3
to be able to calculate consolidated variable for
firm degree of indebtedness */

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';


/* WAVE 1 FINANCIAL DATA */

data finance1; set tz.tz1new;
options linesize=80;
options nolabel;

firm=key;
wave=1;
round=1;

/* trade financing */
tradb=v3412+v3904;
if tradb=. then tradb=0;
tradl=v3413+v3903;
if tradl=. then tradl=0;

/* overdraft */
anyodf=v4701;
banks=v4702;
odraft=v4703;
if odraft=. then odraft=0;

/* formal borrowing */
anyloan=v4704;

frmbb=v48107;
if frmbb=. then frmbb=0;
frmbfi=v48207;
if frmbfi=. then frmbfi=0;
frmbg=v48307;
if frmbg=. then frmbg=0;
frmbo=v48407;
if frmbo=. then frmbo=0;

frmb=frmbb+frmbfi+frmbg+frmbo;

lapply=v5022;
lapprov=v5023;

/* informal borrowing */
infbrf=v52104;
if infbrf=. then infbrf=0;
infbml=v52204;
if infbml=. then infbml=0;
infbig=v52304;
if infbig=. then infbig=0;
infbs=v52404;
if infbs=. then infbs=0;
infbc=v52504;
if infbc=. then infbc=0;
infbos=v52604;
if infbos=. then infbos=0;

infb=infbrf+infbml+infbig+infbs+infbc+infbos;

/* informal lending */
inflrf=v440402;
if inflrf=. then inflrf=0;
infls=v440102;
if infls=. then infls=0;
inflc=v440202;
if inflc=. then inflc=0;
infloe=v440302;
if infloe=. then infloe=0;
inflos=v440602+v440502;
if inflos=. then inflos=0;

infl=inflrf+infls+inflc+infloe+inflos;


/* aggregate financial position */

totb=odraft+frmb+infb+tradb;
totl=infl+tradl;
netb=totb-totl;

keep firm wave round tradb tradl anyodf banks odraft
 frmbb frmbfi frmbg frmbo
frmb lapply lapprov anyinfb infbrf infbml infbig infbs
infbc infboe infbcg infbos infb anyloan inflrf inflml inflig
infls inflc infloe inflcg inflos infl
totb totl netb;

proc sort; by firm round;
proc means; run;


/* WAVE 2 FINANCIAL DATA */

data finance2; set tz.tz2new;
options linesize=80;
options nolabel;

firm=key;
wave=2;
round=2;

/* trade financing */
tradb=v3001+v3004;
if tradb=. then tradb=0;
tradl=v3002+v3003;
if tradl=. then tradl=0;

/* overdraft */
anyodf=v3101;
banks=v3102;
odraft=v3103;
if odraft=. then odraft=0;

/* formal borrowing */
frmbb=v3108r1;
if frmbb=. then frmbb=0;
frmbfi=v3108r2;
if frmbfi=. then frmbfi=0;
frmbg=v3108r3;
if frmbg=. then frmbg=0;
frmbo=v3108r4;
if frmbo=. then frmbo=0;

frmb=frmbb+frmbfi+frmbg+frmbo;

lapply=v3212;

/* informal borrowing */
infbrf=v3303r1;
if infbrf=. then infbrf=0;
infbml=v3303r2;
if infbml=. then infbml=0;
infbig=v3303r3;
if infbig=. then infbig=0;
infbs=v3303r4;
if infbs=. then infbs=0;
infbc=v3303r5;
if infbc=. then infbc=0;
infboe=v3303r6;
if infboe=. then infboe=0;
infbos=v3303r7;
if infbos=. then infbos=0;

infb=infbrf+infbml+infbig+infbs+infbc+infboe+infbos;

/* informal lending */
inflrf=v3401r1;
if inflrf=. then inflrf=0;
infls=v3401r2;
if infls=. then infls=0;
inflc=v3401r3;
if inflc=. then inflc=0;
infloe=v3401r5;
if infloe=. then infloe=0;
inflos=v3401r4+v3401r6;
if inflos=. then inflos=0;

infl=inflrf+infls+inflc+infloe+inflos;


/* aggregate financial position */

totb=odraft+frmb+infb+tradb;
totl=infl+tradl;
netb=totb-totl;

keep firm wave round tradb tradl anyodf banks odraft
 frmbb frmbfi frmbg frmbo
frmb lapply lapprov anyinfb infbrf infbml infbig infbs
infbc infboe infbcg infbos infb anyloan inflrf inflml inflig
infls inflc infloe inflcg inflos infl
totb totl netb;

proc sort; by firm round;
proc means; run;


data finance3; set tz.tz3new;
options linesize=80;
options nolabel;

firm=key;
wave=3;
round=3;

/* trade financing */
tradb=v3405+v3512;
if tradb=. then tradb=0;
tradl=v3509+v3510;
if tradl=. then tradl=0;

/* overdraft */
anyodf=v3601;
banks=v3602;
odraft=v3603;
if odraft=. then odraft=0;

/* formal borrowing */
frmbb=v3711r1;
if frmbb=. then frmbb=0;
frmbfi=v3711r2;
if frmbfi=. then frmbfi=0;
frmbg=v3711r3;
if frmbg=. then frmbg=0;
frmbfb=v3711r4;
if frmbfb=. then frmbfb=0;
frmbo=v3711r5;
if frmbo=. then frmbo=0;

frmb=frmbb+frmbfi+frmbg+frmbfb+frmbo;

lapply=v3718;
lapprov=v3719;

/* informal borrowing */
anyinfb=v3901;

infbrf=v3903r1;
if infbrf=. then infbrf=0;
infbml=v3903r2;
if infbml=. then infbml=0;
infbig=v3903r3;
if infbig=. then infbig=0;
infbs=v3903r4;
if infbs=. then infbs=0;
infbc=v3903r5;
if infbc=. then infbc=0;
infboe=v3903r6;
if infboe=. then infboe=0;
infbos=v3903r7;
if infbos=. then infbos=0;

infb=infbrf+infbml+infbig+infbs+infbc+infboe+infbos;

/* informal lending */
inflrf=v4001r1;
if inflrf=. then inflrf=0;
infls=v4001r2;
if infls=. then infls=0;
inflc=v4001r3;
if inflc=. then inflc=0;
infloe=v4001r5;
if infloe=. then infloe=0;
inflos=v4001r4+v4001r6;
if inflos=. then inflos=0;

infl=inflrf+infls+inflc+infloe+inflos;


/* aggregate financial position */

totb=odraft+frmb+infb+tradb;
totl=infl+tradl;
netb=totb-totl;

keep firm wave round tradb tradl anyodf banks odraft
 frmbb frmbfi frmbg frmbo
frmb lapply lapprov anyinfb infbrf infbml infbig infbs
infbc infboe infbcg infbos infb anyloan inflrf inflml inflig
infls inflc infloe inflcg inflos infl
totb totl netb;

proc sort; by firm round;
proc means; run;


/* combined finance file for Waves 1 to 3 */

data cd.finance; merge finance1 finance2 finance3; by firm round;
proc means; run;
proc sort; by firm;
